IS_PARALLEL = True
LIMIT_INTERP = "<Enter interpolation limit>"
LAST_DATE_CONST = 'yyyy-mm-dd hh:mm:ss'
SAMPLING_RATE = '1min' # sampling rate 
FREQUENCY  = "10min"
THERMAL_ENERGY_CONST = 83.6
DOWNSAMPLE_VALUE = int(FREQUENCY[:-3]) # downsampling ratio
WEEK_MEASUREMENTS = int(10080/int(FREQUENCY[:-3])) # number of measurements in a week
DATA_FILENAME = "<Enter dataset filename>"
TOTAL_VINS = "<Enter total elements>"
STORAGE_DIR = "<Enter storage directory for features>"

DIST_FILENAMES = {
    "euclidean" : "train_euc_dist.npy",
    "manhattan" : "train_man_dist.npy",
    "minkowski" : "train_mink_dist.npy",
    "cosine" : "train_cos_dist.npy",
    "dtw" : "train_dtw_dist.npy"
}
FEATURE_NAMES = ['Home','SOC','delta_soc','weekly_mile','dod','charging_power_level','charging_energy_kwh','weekly_cycle',   'delta_mile', 'delta_energy', 'velocity',]
FEAT_IDX = {'Home':0, 'SOC':1, 'delta_soc':2, 'weekly_mile':3, 'dod':4, 'charging_power_level':5, 'charging_energy_kwh':6, 'weekly_cycle':7,   'delta_mile':8, 'delta_energy':9, 'velocity':10 } 
FEAT_LABEL = {'Home':'Home', 
              'SOC':'SOC%', 
              'delta_soc':'Change in SOC%',
              'weekly_mile':'Mileage',
              'dod':'Depth of Discharge%',
              'charging_power_level':'Charging Power Level',
              'charging_energy_kwh':'Charging Energy kWh',
              'weekly_cycle':'Cycle Number',
              'delta_mile':"Change in mileage", 
              'delta_energy':"change in energy", 
              'velocity': "velocity"}
